//=============================================================================
// Force Fullscreen
//=============================================================================

/*:
 * ==============================================================================
 *  Database Related
 * ------------------------------------------------------------------------------
 *  [MISC][1.25][18/06/2016][Devidra]
 *  []
 * ==============================================================================
 *  Plugin Related
 * ------------------------------------------------------------------------------
 *  @plugindesc  (v1.25) Force Fullscreen
 *  @author Devidra
 * ==============================================================================
 *  Plugin Parameter
 * ------------------------------------------------------------------------------
 *	@param Window Mode
 *	@desc Disable "F4 - Window Mode" possibility
 ( "disabled" to disable )
 *	@default enabled
 * ==============================================================================
 *  @help
 * ==============================================================================
 *                         ~~~~~ Force Fullscreen ~~~~~
 *                                  By Devidra
 * ==============================================================================
 *
 *                               No help available
 *
 * ==============================================================================
 *  Version History
 * ------------------------------------------------------------------------------
 *    v1.00 - 16/6/2016
 *      - Initial Release
 *    v1.10 - 17/6/2016
 *      - Added possibility disabling Window Mode through F4
 *    v1.15 - 17/6/2016
 *      - Fixed compatibility issues
 *    v1.25 - 18/6/2016
 *      - Changed Code for more compatibility
 *      - Console output every function and state
 * ==============================================================================
 */

(function() {

/*
 * ==============================================================================
 *  Get and Set Plugin Parameter and Alias
 * ==============================================================================
*/

var Devscript_name = "Force_Fullscreen";
var Devscript_parameter = "Devscript_parameter";
var Devscript_alias = "Devscript_alias";

// Get Plugin Parameter
	var Devscript = Devscript || {};
	Devscript.parameters = PluginManager.parameters(Devscript_name);

// Set Plugin Parameter into specific array-variable
	var Devscript_parameter = {
			"Windowmode": (Devscript.parameters['Window Mode'] === "disabled") ? Devscript.parameters['Window Mode'] : "enabled",
		};

// Set and get alias function
	Devscript_alias = {
			"Game Boot": Scene_Boot.prototype.start,
			"Switch Fullscreen": Graphics._switchFullScreen,
		};

// Console to get information
	console.log("==========================");
	console.log(Devscript_name);
	console.log("Following function and their states");
	console.log( JSON.stringify(Devscript_parameter, null, 2) );
	console.log("==========================");

/*
 * ==============================================================================
 *  Fullscreen Function
 * ==============================================================================
*/

		Scene_Boot.prototype.start = function() {
			Devscript_alias["Game Boot"].call(this);
			Graphics._requestFullScreen();
		};

/*
 * ==============================================================================
 *  Window Mode Function
 * ==============================================================================
*/

	Graphics._switchFullScreen = function() {
		if (Devscript_parameter["Windowmode"] !== "disabled") {
			Devscript_alias["Switch Fullscreen"].call(this);
		}
	};

/*
 * ==============================================================================
*/

})();
